//
//  ColorPicker.swift
//  Do It
//
//  Created by Jim Dovey on 2/4/20.
//  Copyright © 2020 Jim Dovey. All rights reserved.
//

import SwiftUI

// START:ButtonStyle
fileprivate struct ColorButtonStyle: ButtonStyle {
    func makeBody(configuration: Configuration) -> some View {
        configuration.label
            .clipShape(Circle())
            .overlay(Circle().stroke().foregroundColor(.white))
            .modifier(DoubleShadow(radius: configuration.isPressed ? 1 : 6))
    }
}
// END:ButtonStyle

// START:PickerImpl
struct ColorPicker<Value: ColorInfo>: View {
    @Binding var selectedColor: Value
    // END:PickerImpl
    // START:SelectionBar
    var showSelectionBar: Bool = false
    // START:PickerImpl
    
    var body: some View {
        // END:SelectionBar
        // <literal:elide> ... </literal:elide>
        // START:SelectionBar
        // END:PickerImpl
        // START:PickerView
        VStack(spacing: 16) {
            // END:PickerView
            // <literal:elide> ... </literal:elide>
            // END:SelectionBar
            ColorWheel(color: $selectedColor)

            // START:PickerView
            HStack {
                ForEach(Value.predefined) { color in
                    Button(action: { self.selectedColor = color }) {
                        color.uiColor
                    }
                }
                .frame(maxHeight: 40) // <label id="code.ch5.pickers.predefined.frame" />
            }
            // END:PickerView
            .buttonStyle(ColorButtonStyle())

            // START:SelectionBar
            if showSelectionBar {
                Rectangle()
                    .foregroundColor(selectedColor.uiColor)
                    .overlay(Rectangle().stroke().foregroundColor(.white))
                    .modifier(DoubleShadow(radius: 6))
                    .padding()
                    .frame(maxWidth: 200, maxHeight: 60)
            }
            // START:PickerView
        }
        // END:PickerView
        // START:PickerImpl
    }
    // END:SelectionBar
}
// END:PickerImpl

struct ColorPicker_Previews: PreviewProvider {
    static var previews: some View {
        // START:Preview
        StatefulPreviewWrapper(TodoItemList.Color.blue) {
            ColorPicker(selectedColor: $0, showSelectionBar: true)
        }
        // END:Preview
    }
}
